/*
 * Decompiled with CFR 0.152.
 */
package calendar.core;

import calendar.core.CacheMap;
import calendar.core.Day;
import calendar.core.Holiday;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;

public final class Month {
    private static Map cache = new CacheMap();
    private GregorianCalendar calendar;
    private List days;

    private Month(Calendar calendar) {
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        this.calendar = new GregorianCalendar(n, n2, calendar.get(5));
        Holiday holiday = new Holiday();
        this.days = new ArrayList();
        int n3 = 1;
        int n4 = this.getNumberOfDays();
        while (n3 <= n4) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(n, n2, n3);
            this.days.add(holiday.getDay(gregorianCalendar));
            ++n3;
        }
    }

    public int getYearNumber() {
        return this.calendar.get(1);
    }

    public int getMonthNumber() {
        return this.calendar.get(2) + 1;
    }

    public Day getDay(int n) {
        return (Day)this.days.get(n - 1);
    }

    public int getNumberOfDays() {
        int n = this.calendar.get(2);
        switch (n) {
            case 1: {
                return 28 + (this.isLeapYear() ? 1 : 0);
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                return 30;
            }
        }
        return 31;
    }

    public boolean isLeapYear() {
        return this.calendar.isLeapYear(this.getYearNumber());
    }

    public Month getRelative(int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.calendar.getTime());
        calendar.add(2, n);
        return Month.getInstance(calendar);
    }

    public static Month getInstance() {
        return Month.getInstance(Calendar.getInstance());
    }

    public static Month getInstance(int n, int n2) {
        return Month.getInstance(new GregorianCalendar(n, n2 - 1, 1));
    }

    public static Month getInstance(Calendar calendar) {
        int n;
        int n2 = calendar.get(1);
        String string = String.valueOf(n2 * 100 + (n = calendar.get(2) + 1));
        Month month = (Month)cache.get(string);
        if (month == null) {
            month = new Month(calendar);
            cache.put(string, month);
        }
        return month;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\u897f\u66a6 ");
        switch (this.calendar.get(0)) {
            case 0: {
                stringBuffer.append("\u7d00\u5143\u524d ");
            }
        }
        stringBuffer.append(this.calendar.get(1));
        stringBuffer.append("\u5e74 ");
        stringBuffer.append(this.calendar.get(2) + 1);
        stringBuffer.append("\u6708");
        return stringBuffer.toString();
    }
}

