/*
 * Decompiled with CFR 0.152.
 */
package calendar.core;

import java.util.Calendar;
import java.util.GregorianCalendar;

public final class Day {
    private Calendar calendar;
    private boolean holiday;
    private String holidayName;

    protected Day(Calendar calendar) {
        this(calendar, false, "");
    }

    protected Day(Calendar calendar, boolean bl, String string) {
        this.initialize(calendar);
        this.holiday = bl;
        this.holidayName = string;
    }

    private void initialize(Calendar calendar) {
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        int n3 = calendar.get(5);
        this.calendar = new GregorianCalendar(n, n2, n3);
    }

    public int getNumber() {
        return this.calendar.get(5);
    }

    public int getDayOfWeek() {
        return this.calendar.get(7);
    }

    public String getDayOfWeekToString() {
        switch (this.getDayOfWeek()) {
            case 1: {
                return "\u65e5";
            }
            case 2: {
                return "\u6708";
            }
            case 3: {
                return "\u706b";
            }
            case 4: {
                return "\u6c34";
            }
            case 5: {
                return "\u6728";
            }
            case 6: {
                return "\u91d1";
            }
            case 7: {
                return "\u571f";
            }
        }
        return "\uff1f";
    }

    public boolean isHoliday() {
        return this.holiday;
    }

    public String getHolidayName() {
        return this.holidayName;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\u897f\u66a6 ");
        stringBuffer.append(this.calendar.get(1));
        stringBuffer.append("\u5e74 ");
        stringBuffer.append(this.calendar.get(2) + 1);
        stringBuffer.append("\u6708 ");
        stringBuffer.append(this.calendar.get(5));
        stringBuffer.append("\u65e5 ");
        stringBuffer.append(this.getDayOfWeekToString());
        stringBuffer.append("\u66dc\u65e5");
        if (this.holiday) {
            stringBuffer.append("    \u795d\u65e5\u30fb");
            stringBuffer.append(this.holidayName);
        }
        return stringBuffer.toString();
    }
}

