package calendar.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.Calendar;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.text.JTextComponent;

import calendar.core.Day;
import calendar.core.Month;

/**
 * fth̃J_[r[łB
 * t[łAvbgłlɎgpł܂B
 */
public final class GraphicView extends JApplet {
    
    private static final String TITLE = "{̏jJ_[";
    private static final Color SATURDAY_COLOR = new Color(224, 224, 255);
    private static final Color SUNDAY_COLOR = new Color(255, 224, 224);
    private static final Color HOLIDAY_COLOR = new Color(255, 168, 168);
    private static final KeyStroke ENTER_KEY = KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0);
    
    private RootPaneContainer rootPane;
    
    private JPanel topPanel; // N\镔
    private GridLayout calendarMainGrid; // J_[̓t
    private JPanel calendarMainPanel; // J_[̓t
    private JTextComponent messageArea; // {^Ƃɕ\GA
    
    private JButton previousYearButton;
    private JButton nextYearButton;
    private JButton previousMonthButton;
    private JButton nextMonthButton;
    private JButton absoluteButton;
    private JTextField textYear;
    private JTextField textMonth;
    
    private Month currentMonth;
    
    /**
     * yC̃r[𐶐܂B
     * ́AAvbg̏Ɏgp܂B
     */
    public GraphicView() {
        
        this.rootPane = this;
        
    }
    
    /**
     * r[𐶐܂B
     * @param rootPane yCƂȂR|[lg
     */
    public GraphicView(RootPaneContainer rootPane) {
        
        this.rootPane = rootPane;
        
    }
    
    /**
     * uO̔Nv{^̃CxgłB
     */
    private ActionListener onPressPreviousYearButton = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
            doEvents(this);
        }
    };
    
    /**
     * u̔Nv{^̃CxgłB
     */
    private ActionListener onPressNextYearButton = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
            doEvents(this);
        }
    };
    
    /**
     * uǑv{^̃CxgłB
     */
    private ActionListener onPressPreviousMonthButton = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
            doEvents(this);
        }
    };
    
    /**
     * ǔv{^̃CxgłB
     */
    private ActionListener onPressNextMonthButton = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
            doEvents(this);
        }
    };
    
    /**
     * uNwv{^̃CxgłB
     */
    private Action onPressAbsoluteButton = new AbstractAction() {
        public void actionPerformed(ActionEvent e) {
            doEvents(this);
        }
    };
    
    /**
     * {^Cxg܂B
     * @param action {^̃CxgANV
     */
    private void doEvents(ActionListener action) {
        
        // Cxg̓{^𖳌
        previousYearButton.setEnabled(false);
        nextYearButton.setEnabled(false);
        previousMonthButton.setEnabled(false);
        nextMonthButton.setEnabled(false);
        absoluteButton.setEnabled(false);
        
        // bZ[W
        messageArea.setText("");
        
        try {
            
            if (action == onPressPreviousYearButton) {
                
                // O̔N
                setCalendar(currentMonth.getRelative(-12));
                previousYearButton.setEnabled(true);
                previousYearButton.requestFocus();
                
            } else if (action == onPressNextYearButton) {
                
                // ̔N
                setCalendar(currentMonth.getRelative(+12));
                nextYearButton.setEnabled(true);
                nextYearButton.requestFocus();
                
            } else if (action == onPressPreviousMonthButton) {
                
                // Ǒ
                setCalendar(currentMonth.getRelative(-1));
                previousMonthButton.setEnabled(true);
                previousMonthButton.requestFocus();
                
            } else if (action == onPressNextMonthButton) {
                
                // ̌
                setCalendar(currentMonth.getRelative(+1));
                nextMonthButton.setEnabled(true);
                nextMonthButton.requestFocus();
                
            } else if (action == onPressAbsoluteButton) {
                
                // Nw
                int yearNumber = Integer.parseInt(textYear.getText());
                int monthNumber = Integer.parseInt(textMonth.getText());
                setCalendar(Month.getInstance(yearNumber, monthNumber));
                absoluteButton.setEnabled(true);
                absoluteButton.requestFocus();
                
            } else if (action == onPressPreviousYearButton) {
                
                // NZ
                setCalendar(currentMonth.getRelative(+12));
                
            }
            
        } catch (IllegalArgumentException ex) {
            
            // A[g\
            JOptionPane.showMessageDialog(rootPane.getContentPane(), ex.getMessage());
            
        } finally {
            
            // 
            previousYearButton.setEnabled(true);
            nextYearButton.setEnabled(true);
            previousMonthButton.setEnabled(true);
            nextMonthButton.setEnabled(true);
            absoluteButton.setEnabled(true);
            
        }
        
    }
    
    /**
     * EBhEăI[v܂B
     */
    public void createMainWindow() {
        
        // wb_̏
        JPanel headerPanel = new JPanel(new GridLayout(1, 7));
        JButton sunday = new JButton("");
        headerPanel.add(sunday);
        headerPanel.add(new JButton(""));
        headerPanel.add(new JButton(""));
        headerPanel.add(new JButton(""));
        headerPanel.add(new JButton(""));
        headerPanel.add(new JButton(""));
        JButton saturday = new JButton("y");
        headerPanel.add(saturday);
        
        // bZ[W\GA
        JPanel messagePanel = new JPanel(new BorderLayout());
        messageArea = new JTextField();
        messageArea.setFont(new Font("SansSerif", Font.BOLD, 12));
        messagePanel.add(messageArea, BorderLayout.CENTER);
        
        // ̓p[c̏
        previousYearButton = new JButton("O̔N");
        previousYearButton.addActionListener(onPressPreviousYearButton);
        nextYearButton = new JButton("̔N");
        nextYearButton.addActionListener(onPressNextYearButton);
        previousMonthButton = new JButton("Ǒ");
        previousMonthButton.addActionListener(onPressPreviousMonthButton);
        nextMonthButton = new JButton("̌");
        nextMonthButton.addActionListener(onPressNextMonthButton);
        absoluteButton = new JButton("Nw");
        absoluteButton.addActionListener(onPressAbsoluteButton);
        textYear = new JTextField(4);
        InputMap textYearInputMap = new InputMap();
        textYearInputMap.setParent(textYear.getInputMap());
        textYearInputMap.put(ENTER_KEY, onPressAbsoluteButton);
        textYear.setInputMap(JComponent.WHEN_FOCUSED, textYearInputMap);
        textMonth = new JTextField(2);
        InputMap textMonthInputMap = new InputMap();
        textMonthInputMap.setParent(textMonth.getInputMap());
        textMonthInputMap.put(ENTER_KEY, onPressAbsoluteButton);
        textMonth.setInputMap(JComponent.WHEN_FOCUSED, textMonthInputMap);
        
        // ͕̔zu
        JPanel inputPanel = new JPanel();
        JPanel inputPanelInner0 = new JPanel();
        JPanel inputPanelInner1 = new JPanel();
        JPanel inputPanelInner2 = new JPanel(new GridLayout(2, 1));
        JPanel inputPanelInner3 = new JPanel();
        inputPanelInner0.add(textYear);
        inputPanelInner0.add(new JLabel("N"));
        inputPanelInner0.add(textMonth);
        inputPanelInner0.add(new JLabel(""));
        inputPanelInner1.add(previousYearButton);
        inputPanelInner1.add(nextYearButton);
        inputPanelInner2.add(inputPanelInner0);
        inputPanelInner2.add(absoluteButton);
        inputPanelInner3.add(previousMonthButton);
        inputPanelInner3.add(nextMonthButton);
        inputPanel.add(inputPanelInner1);
        inputPanel.add(inputPanelInner2);
        inputPanel.add(inputPanelInner3);
        
        // R|[lg̔zu
        topPanel = new JPanel();
        JPanel centerPanel = new JPanel(new BorderLayout());
        calendarMainGrid = new GridLayout(6, 7);
        calendarMainPanel = new JPanel(calendarMainGrid);
        centerPanel.add(headerPanel, BorderLayout.NORTH);
        centerPanel.add(calendarMainPanel, BorderLayout.CENTER);
        centerPanel.add(messagePanel, BorderLayout.SOUTH);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(topPanel, BorderLayout.NORTH);
        panel.add(new JLabel("        "), BorderLayout.WEST);
        panel.add(centerPanel, BorderLayout.CENTER);
        panel.add(new JLabel("        "), BorderLayout.EAST);
        panel.add(inputPanel, BorderLayout.SOUTH);
        
        rootPane.getContentPane().add(panel);
        
    }
    
    /**
     * w肵ÑJ_[\܂B
     * @param month IuWFNg
     */
    private void setCalendar(Month month) {
        
        currentMonth = month;
        
        topPanel.removeAll();
        calendarMainPanel.removeAll();
        
        textYear.setText(String.valueOf(month.getYearNumber()));
        textMonth.setText(String.valueOf(month.getMonthNumber()));
        
        topPanel.add(new JLabel(month.toString()));
        
        // PT̏
        int firstSaturday = 7;
        for (int i = 1, n = month.getNumberOfDays(); i <= n; i++) {
            
            // ŏ̓yjo
            Day day = month.getDay(i);
            if (day.getDayOfWeek() == Calendar.SATURDAY) {
                firstSaturday = i;
                break;
            }
            
        }
        
        // P܂ł̃Xy[X𖄂߂
        int spaceSize = 7 - firstSaturday;
        if (spaceSize != 0) {
            for (int i = 0; i < spaceSize; i++) {
                JButton button = new JButton();
                button.setBackground(Color.white);
                calendarMainPanel.add(button);
            }
        }
        
        
        // t\
        for (int i = 1, n = month.getNumberOfDays(); i <= n; i++) {
            
            Day day = month.getDay(i);
            StringBuffer sb = new StringBuffer();
            
            Color color = Color.white;
            int dayOfWeek = day.getDayOfWeek();
            if (dayOfWeek == Calendar.SATURDAY) {
                // yj
                color = SATURDAY_COLOR;
            } else if (dayOfWeek == Calendar.SUNDAY) {
                // j
                color = SUNDAY_COLOR;
            }
            if (day.isHoliday()) {
                // j
                color = HOLIDAY_COLOR;
            }
            
            sb.append(i);
            
            JButton button = new JButton(sb.toString());
            button.setBackground(color);
            button.addActionListener(new OnClickDayButton(messageArea, day));
            calendarMainPanel.add(button);
            
        }
        
//        // ŏIT̏
//        int lastSaturday = 0;
//        for (int i = month.getNumberOfDays(), n = 0; i >= 1; i--, n++) {
//            
//            // Ō̓yjo
//            Day day = month.getDay(i);
//            if (day.getDayOfWeek() == Calendar.SATURDAY) {
//                lastSaturday = n;
//                break;
//            }
//            
//        }
        
        // c̃Xy[X𖄂߂
        int remains = 42 - month.getNumberOfDays() - spaceSize;
        for (int i = 0; i < remains; i++) {
            JButton button = new JButton();
            button.setBackground(Color.white);
            calendarMainPanel.add(button);
        }
        
        // ʂ̃tbV
        topPanel.validate();
        calendarMainPanel.validate();
        
    }
    
    /**
     * t{^ꂽ̃CxgłB
     */
    private static class OnClickDayButton implements ActionListener {
        
        private JTextComponent text;
        private Day day;
        
        /**
         * Cxg𐶐܂B
         * @param text o͐
         * @param day IuWFNg
         */
        OnClickDayButton(JTextComponent text, Day day) {
            
            this.text = text;
            this.day = day;
            
        }
        
        /**
         * CxgƂɎs܂B
         * @param e Cxg
         */
        public void actionPerformed(ActionEvent e) {
            
            text.setText(day.toString());
            
        }
        
    }
    
    /**
     * AppletŃAvP[V܂B
     */
    public void init() {
        
        createMainWindow();
        setCalendar(Month.getInstance());
        
    }
    
    /**
     * GraphicViewŃAvP[VJn܂B
     * @param args s
     */
    public static void main(String[] args) {
        
        JFrame frame = new JFrame();
        GraphicView view = new GraphicView(frame);
        view.createMainWindow();
        view.setCalendar(Month.getInstance());
        
        frame.setTitle(TITLE);
        frame.setSize(480, 360);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.show();
        frame.validate();
        
    }
    
}
