/*
 * Decompiled with CFR 0.152.
 */
package calendar.view;

import calendar.core.Day;
import calendar.core.Month;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.text.JTextComponent;

public final class GraphicView
extends JApplet {
    private static final String TITLE = "\u65e5\u672c\u306e\u795d\u65e5\u30ab\u30ec\u30f3\u30c0\u30fc";
    private static final Color SATURDAY_COLOR = new Color(224, 224, 255);
    private static final Color SUNDAY_COLOR = new Color(255, 224, 224);
    private static final Color HOLIDAY_COLOR = new Color(255, 168, 168);
    private static final KeyStroke ENTER_KEY = KeyStroke.getKeyStroke(10, 0);
    private RootPaneContainer rootPane;
    private JPanel topPanel;
    private GridLayout calendarMainGrid;
    private JPanel calendarMainPanel;
    private JTextComponent messageArea;
    private JButton previousYearButton;
    private JButton nextYearButton;
    private JButton previousMonthButton;
    private JButton nextMonthButton;
    private JButton absoluteButton;
    private JTextField textYear;
    private JTextField textMonth;
    private Month currentMonth;
    private ActionListener onPressPreviousYearButton = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            GraphicView.this.doEvents(this);
        }
    };
    private ActionListener onPressNextYearButton = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            GraphicView.this.doEvents(this);
        }
    };
    private ActionListener onPressPreviousMonthButton = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            GraphicView.this.doEvents(this);
        }
    };
    private ActionListener onPressNextMonthButton = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            GraphicView.this.doEvents(this);
        }
    };
    private Action onPressAbsoluteButton = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            GraphicView.this.doEvents(this);
        }
    };

    public GraphicView() {
        this.rootPane = this;
    }

    public GraphicView(RootPaneContainer rootPaneContainer) {
        this.rootPane = rootPaneContainer;
    }

    private void doEvents(ActionListener actionListener) {
        this.previousYearButton.setEnabled(false);
        this.nextYearButton.setEnabled(false);
        this.previousMonthButton.setEnabled(false);
        this.nextMonthButton.setEnabled(false);
        this.absoluteButton.setEnabled(false);
        this.messageArea.setText("");
        try {
            block9: {
                try {
                    if (actionListener == this.onPressPreviousYearButton) {
                        this.setCalendar(this.currentMonth.getRelative(-12));
                        this.previousYearButton.setEnabled(true);
                        this.previousYearButton.requestFocus();
                        break block9;
                    }
                    if (actionListener == this.onPressNextYearButton) {
                        this.setCalendar(this.currentMonth.getRelative(12));
                        this.nextYearButton.setEnabled(true);
                        this.nextYearButton.requestFocus();
                        break block9;
                    }
                    if (actionListener == this.onPressPreviousMonthButton) {
                        this.setCalendar(this.currentMonth.getRelative(-1));
                        this.previousMonthButton.setEnabled(true);
                        this.previousMonthButton.requestFocus();
                        break block9;
                    }
                    if (actionListener == this.onPressNextMonthButton) {
                        this.setCalendar(this.currentMonth.getRelative(1));
                        this.nextMonthButton.setEnabled(true);
                        this.nextMonthButton.requestFocus();
                        break block9;
                    }
                    if (actionListener == this.onPressAbsoluteButton) {
                        int n = Integer.parseInt(this.textYear.getText());
                        int n2 = Integer.parseInt(this.textMonth.getText());
                        this.setCalendar(Month.getInstance(n, n2));
                        this.absoluteButton.setEnabled(true);
                        this.absoluteButton.requestFocus();
                        break block9;
                    }
                    if (actionListener != this.onPressPreviousYearButton) break block9;
                    this.setCalendar(this.currentMonth.getRelative(12));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    JOptionPane.showMessageDialog(this.rootPane.getContentPane(), illegalArgumentException.getMessage());
                    Object var5_6 = null;
                    this.previousYearButton.setEnabled(true);
                    this.nextYearButton.setEnabled(true);
                    this.previousMonthButton.setEnabled(true);
                    this.nextMonthButton.setEnabled(true);
                    this.absoluteButton.setEnabled(true);
                }
            }
            Object var5_5 = null;
            this.previousYearButton.setEnabled(true);
            this.nextYearButton.setEnabled(true);
            this.previousMonthButton.setEnabled(true);
            this.nextMonthButton.setEnabled(true);
            this.absoluteButton.setEnabled(true);
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.previousYearButton.setEnabled(true);
            this.nextYearButton.setEnabled(true);
            this.previousMonthButton.setEnabled(true);
            this.nextMonthButton.setEnabled(true);
            this.absoluteButton.setEnabled(true);
            throw throwable;
        }
    }

    public void createMainWindow() {
        JPanel jPanel = new JPanel(new GridLayout(1, 7));
        JButton jButton = new JButton("\u65e5");
        jPanel.add(jButton);
        jPanel.add(new JButton("\u6708"));
        jPanel.add(new JButton("\u706b"));
        jPanel.add(new JButton("\u6c34"));
        jPanel.add(new JButton("\u6728"));
        jPanel.add(new JButton("\u91d1"));
        JButton jButton2 = new JButton("\u571f");
        jPanel.add(jButton2);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.messageArea = new JTextField();
        this.messageArea.setFont(new Font("SansSerif", 1, 12));
        jPanel2.add((Component)this.messageArea, "Center");
        this.previousYearButton = new JButton("\u524d\u306e\u5e74");
        this.previousYearButton.addActionListener(this.onPressPreviousYearButton);
        this.nextYearButton = new JButton("\u6b21\u306e\u5e74");
        this.nextYearButton.addActionListener(this.onPressNextYearButton);
        this.previousMonthButton = new JButton("\u524d\u306e\u6708");
        this.previousMonthButton.addActionListener(this.onPressPreviousMonthButton);
        this.nextMonthButton = new JButton("\u6b21\u306e\u6708");
        this.nextMonthButton.addActionListener(this.onPressNextMonthButton);
        this.absoluteButton = new JButton("\u5e74\u6708\u6307\u5b9a");
        this.absoluteButton.addActionListener(this.onPressAbsoluteButton);
        this.textYear = new JTextField(4);
        InputMap inputMap = new InputMap();
        inputMap.setParent(this.textYear.getInputMap());
        inputMap.put(ENTER_KEY, this.onPressAbsoluteButton);
        this.textYear.setInputMap(0, inputMap);
        this.textMonth = new JTextField(2);
        InputMap inputMap2 = new InputMap();
        inputMap2.setParent(this.textMonth.getInputMap());
        inputMap2.put(ENTER_KEY, this.onPressAbsoluteButton);
        this.textMonth.setInputMap(0, inputMap2);
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel(new GridLayout(2, 1));
        JPanel jPanel7 = new JPanel();
        jPanel4.add(this.textYear);
        jPanel4.add(new JLabel("\u5e74"));
        jPanel4.add(this.textMonth);
        jPanel4.add(new JLabel("\u6708"));
        jPanel5.add(this.previousYearButton);
        jPanel5.add(this.nextYearButton);
        jPanel6.add(jPanel4);
        jPanel6.add(this.absoluteButton);
        jPanel7.add(this.previousMonthButton);
        jPanel7.add(this.nextMonthButton);
        jPanel3.add(jPanel5);
        jPanel3.add(jPanel6);
        jPanel3.add(jPanel7);
        this.topPanel = new JPanel();
        JPanel jPanel8 = new JPanel(new BorderLayout());
        this.calendarMainGrid = new GridLayout(6, 7);
        this.calendarMainPanel = new JPanel(this.calendarMainGrid);
        jPanel8.add((Component)jPanel, "North");
        jPanel8.add((Component)this.calendarMainPanel, "Center");
        jPanel8.add((Component)jPanel2, "South");
        JPanel jPanel9 = new JPanel(new BorderLayout());
        jPanel9.add((Component)this.topPanel, "North");
        jPanel9.add((Component)new JLabel("        "), "West");
        jPanel9.add((Component)jPanel8, "Center");
        jPanel9.add((Component)new JLabel("        "), "East");
        jPanel9.add((Component)jPanel3, "South");
        this.rootPane.getContentPane().add(jPanel9);
    }

    private void setCalendar(Month month) {
        Serializable serializable;
        int n;
        this.currentMonth = month;
        this.topPanel.removeAll();
        this.calendarMainPanel.removeAll();
        this.textYear.setText(String.valueOf(month.getYearNumber()));
        this.textMonth.setText(String.valueOf(month.getMonthNumber()));
        this.topPanel.add(new JLabel(month.toString()));
        int n2 = 7;
        int n3 = 1;
        int n4 = month.getNumberOfDays();
        while (n3 <= n4) {
            Day day = month.getDay(n3);
            if (day.getDayOfWeek() == 7) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        int n5 = 7 - n2;
        if (n5 != 0) {
            n = 0;
            while (n < n5) {
                JButton jButton = new JButton();
                jButton.setBackground(Color.white);
                this.calendarMainPanel.add(jButton);
                ++n;
            }
        }
        n = 1;
        int n6 = month.getNumberOfDays();
        while (n <= n6) {
            Day day = month.getDay(n);
            StringBuffer stringBuffer = new StringBuffer();
            serializable = Color.white;
            int n7 = day.getDayOfWeek();
            if (n7 == 7) {
                serializable = SATURDAY_COLOR;
            } else if (n7 == 1) {
                serializable = SUNDAY_COLOR;
            }
            if (day.isHoliday()) {
                serializable = HOLIDAY_COLOR;
            }
            stringBuffer.append(n);
            JButton jButton = new JButton(stringBuffer.toString());
            jButton.setBackground((Color)serializable);
            jButton.addActionListener(new OnClickDayButton(this.messageArea, day));
            this.calendarMainPanel.add(jButton);
            ++n;
        }
        int n8 = 42 - month.getNumberOfDays() - n5;
        int n9 = 0;
        while (n9 < n8) {
            serializable = new JButton();
            ((JComponent)serializable).setBackground(Color.white);
            this.calendarMainPanel.add((Component)serializable);
            ++n9;
        }
        this.topPanel.validate();
        this.calendarMainPanel.validate();
    }

    public void init() {
        this.createMainWindow();
        this.setCalendar(Month.getInstance());
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        GraphicView graphicView = new GraphicView(jFrame);
        graphicView.createMainWindow();
        graphicView.setCalendar(Month.getInstance());
        jFrame.setTitle(TITLE);
        ((Component)jFrame).setSize(480, 360);
        jFrame.setDefaultCloseOperation(3);
        jFrame.show();
        jFrame.validate();
    }

    private static class OnClickDayButton
    implements ActionListener {
        private JTextComponent text;
        private Day day;

        OnClickDayButton(JTextComponent jTextComponent, Day day) {
            this.text = jTextComponent;
            this.day = day;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.text.setText(this.day.toString());
        }
    }
}

